#include "Window.hpp"
#include "Scene.hpp"

#include "Callbacks/Keyboard.hpp"
#include "Callbacks/Reshape.hpp"
#include "Callbacks/Timer.hpp"
#include "Callbacks/Close.hpp"

#include "Sound/Music.hpp"

#include <GL/glew.h>

#include <iostream>

#include <time.h>

int main (int argc, char** argv)
{
	unsigned int nbParticles = 500000;	// Default number
	bool customNumber = false;
	
	srand((unsigned int)time(NULL));
	
	// Retrieve the argument
	if ( argc == 2 )
	{
		if ( sscanf(argv[1],"%ud",&nbParticles) == 1 )
			customNumber = true;
	}
	
#ifdef _DEBUG
    Window::getInstance().create(argc, argv);
#else
	Window::getInstance().create(argc, argv,1280,800,0,0,"Particles",true);
#endif
	
	Window::getInstance().setKeyboardCallback(&callback::keyboard);
	Window::getInstance().setTimerCallback(15, &callback::timer, 15);
	Window::getInstance().setCloseCallback(&callback::cleanOut);
	Window::getInstance().setReshapeCallback(&callback::reshape);

	// Glew might be initialised after starting a window instance
	GLenum err = glewInit();
	if ( err != GLEW_OK )
	{
		std::cerr << "Error while initialising GLEW -> " << glewGetString(err) << std::endl;
		Window::deleteInstance();
		return EXIT_FAILURE;
	}
	
	// Check if the machine is capable of rendering our scene
	if ( !glewIsSupported("GL_ARB_shading_language_100") )
	{
		std::cerr << "Error: the shading language is not supported on your machine" << std::endl;
		Window::deleteInstance();
		return EXIT_FAILURE;
	}
	if ( !glewIsSupported("GL_ARB_shader_objects") )
	{
		std::cerr << "Error: the shader objects are not supported on your machine" << std::endl;
		Window::deleteInstance();
		return EXIT_FAILURE;
	}
	if ( !glewIsSupported("GL_ARB_vertex_shader") )
	{
		std::cerr << "Error: the vertex shader are not supported on your machine" << std::endl;
		Window::deleteInstance();
		return EXIT_FAILURE;
	}
	if ( !glewIsSupported("GL_ARB_fragment_shader") )
	{
		std::cerr << "Error: the fragment shader are not supported on your machine" << std::endl;
		Window::deleteInstance();
		return EXIT_FAILURE;
	}

	if ( !(Music::getInstance()).create() )
	{
		Window::deleteInstance();
		Music::deleteInstance();
		return EXIT_FAILURE;
	}
	
	if ( !(Music::getInstance()).loadFile("Data/Metroid.mp3") )
	{
		Window::deleteInstance();
		Music::deleteInstance();
		return EXIT_FAILURE;
	}
	
	(Music::getInstance()).play();

	if ( !Scene::getInstance().create(nbParticles) )
	{
		Window::deleteInstance();
		Music::deleteInstance();
		Scene::deleteInstance();
		return EXIT_FAILURE;
	}
	
	Window::getInstance().run();
    
    Window::deleteInstance();
    
    return 0;
}
