#ifndef __WINDOW_HPP__
#define __WINDOW_HPP__

#include "global.hpp"

#include "Utils/Singleton.hpp"

#include <iostream>

/**
 * Window class : gives a window to display the OpenGL Scene
 * Uses the singleton pattern
 * @author Alexandre LAURENT
 */
class Window : public Utils::Singleton<Window>
{
	private :		
		int window_id;
		
	public:
		~Window(void);
		
		/**
			Create the window
			@param const int argc the number of arguments when the program starts
			@param const char** the arguments when the program starts
			@param const unsigned int  window width
			@param const unsigned int  window height
			@param const unsigned int  window position on the x axis
			@param const unsigned int  window position on the y axis
			@param const char*  window name
			@param const bool  fullscreen mode
			@return static Window* the window 
		*/
		bool create(int argc = 0, char** argv = NULL,
			   			 const unsigned int window_width = DEFAULT_WINDOW_WIDTH,const unsigned int window_height = DEFAULT_WINDOW_HEIGHT,
			   			 const unsigned int window_position_x = DEFAULT_WINDOW_POSITION_X,const unsigned int window_position_y = DEFAULT_WINDOW_POSITION_Y,
			   			 const char* window_name = DEFAULT_WINDOW_NAME,
			   			 const bool fullscreen = false);	///< Create the window
				
		void run(void);		///< Start the main loop
		
		void setKeyboardCallback(void (*keyboardCallback) (unsigned char, int, int)) const;		///< Set the Keyboard Callback function called when a key is pressed
		void setReshapeCallback(void (*reshapeCallback) (int width, int height)) const;		///< Set the reshape Callback function called when the window is modified
		void setTimerCallback(unsigned int ms, void (*timerCallback) (int value), int value) const;		///< Set the timer callback function called after ms milli seconds
		void setCloseCallback(void (*closeCallback) (void))const;		///< Set the close callback function called when the window is closed
};

#endif
