#include "Window.hpp"

#include <GL/freeglut.h>

#include "Callbacks/Reshape.hpp"

#include <iostream>

Window :: ~Window ()
{
    glutDestroyWindow(window_id);
	// To stop the glutMainLoop | Special freeglut
	glutLeaveMainLoop();
	std::cout << "Window deleted" << std::endl;
}

bool Window :: create(int argc /*= 0*/, char** argv /*= NULL*/,
				 const unsigned int window_width /*= DEFAULT_WINDOW_WIDTH*/,const unsigned int window_height /*= DEFAULT_WINDOW_HEIGHT*/,
				 const unsigned int window_position_x /*= DEFAULT_WINDOW_POSITION_X*/,const unsigned int window_position_y /*= DEFAULT_WINDOW_POSITION_Y*/,
				 const char* window_name /*= DEFAULT_WINDOW_NAME*/,
				 const bool fullscreen /*= false*/)
{    
	glutInit(&argc,argv);
	
    // Enables options for the window
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGB);
	
	// Window settings
	glutInitWindowSize(window_width, window_height);
	glutInitWindowPosition(window_position_x, window_position_y);
    
    // Creates the window
	if ( ( window_id = glutCreateWindow(window_name)) == 0 )
	{
		std::cerr << "The window creation fails" << std::endl;
		return false;
	}
	
	if ( fullscreen )
		glutFullScreen();
	
	std::cout << "Window created ; Size: " << glutGet(GLUT_WINDOW_WIDTH) << "," << glutGet(GLUT_WINDOW_HEIGHT) << std::endl;
	return true;
}

void Window :: run(void)
{
	// The glutReshapeCallback doesn't work, so a reset the windows size here
	callback::reshape(glutGet(GLUT_WINDOW_WIDTH), glutGet(GLUT_WINDOW_HEIGHT));
	glutMainLoop();
}

void Window :: setKeyboardCallback(void (*keyboardCallback) (unsigned char, int, int)) const
{
	glutKeyboardFunc(keyboardCallback);
}

void Window :: setReshapeCallback(void (*reshapeCallback) (int width, int height)) const
{
	glutReshapeFunc(reshapeCallback);
}

void Window :: setTimerCallback(const unsigned int ms, void (*timerCallback) (int value), const int value) const
{
	glutTimerFunc(ms, timerCallback, value);
}

void Window :: setCloseCallback(void (*closeCallback) (void))const
{
	glutCloseFunc(closeCallback);
}
