#ifndef __RANDOM_HPP__
#define __RANDOM_HPP__

#include <cstdlib>
#include <cmath>
#include "../Math/Vertex3.hpp"

namespace Utils
{
	/**
	 * random function that generate number into a range
	 * @param const float minimum range
	 * @param const float maximum range
	 * @return float the random number generated
	 */
	inline float random(const float min, const float max)
	{
		return min + (rand()/(float)RAND_MAX) * (max-min);
	}

	/**
	 * random function that generate a Vertex3 into a range
	 * @param const float the minimum inclination
	 * @param const float the maximum inclination
	 * @param const float the minimum orientation
	 * @param const float the maximum orientation
	 * @param const float the minimum force
	 * @param const float the maximum force
	 * @return float the random Vertex3 generated
	 */
	Math::Vertex3 randomVertex3(const float inclination_min, const float inclination_max, const float orientation_min, const float orientation_max, const float force_min, const float force_max)
	{
		float inclination = random(inclination_min, inclination_max);
		float orientation = random(orientation_min, orientation_max);
		float force = random(force_min, force_max);

		return Math::Vertex3(
								force*cosf(inclination) * cosf(orientation),
								force*cosf(inclination) * sinf(orientation),
								force * sinf(inclination)
								);
	}
}

#endif
