#ifndef __TEXT_HPP__
#define __TEXT_HPP__

#include "../Types/Colours.hpp"

#include <string>

/**
 * Class Text: Render some textual information to the screen
 * @author Alexandre LAURENT
 */
class Text
{
	public:
		
		/**
		 * Function to render a string on the screen using 2D position
		 * @const unsigned int the position on the x axis in pixel unit related to the window
		 * @const unsigned int the position on the y axis in pixel unit related to the window
		 * @const std::string& the string to display
		 * @const Colour3& the text colour
		 */
		static void renderString(const unsigned int xPosition, const unsigned int yPosition, const std::string& string,const Colour3& colour);
};

#endif
