#include "Text.hpp"

#include <GL/freeglut.h>

void Text :: renderString(const unsigned int xPosition, const unsigned int yPosition, const std::string& string, const Colour3& colour )
{
	// To be sure that the text is always display
	glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
	
	// Swap to the 2D mode
    glMatrixMode(GL_MODELVIEW);
   	glPushMatrix();
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();
    
    // Set the 2D mode with the size of the window
    gluOrtho2D(0,glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT));
    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	// Use the colour
	glColor3f(colour.r, colour.g, colour.b);

	// Place the render coordinates
	glRasterPos2d(xPosition, glutGet(GLUT_WINDOW_HEIGHT) - yPosition);
	
	glutBitmapString(GLUT_BITMAP_9_BY_15, (const unsigned char*)string.c_str());
	
	// Set a default colour
	glColor3f(1,1,1);
	
	// Switch back to the initial mode
	glMatrixMode(GL_PROJECTION);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
	
	// Reset the settings
	glEnable(GL_TEXTURE_2D);
    glEnable(GL_DEPTH_TEST);
}
