#ifndef __MUSIC_HPP__
#define __MUSIC_HPP__

#include "../Utils/Singleton.hpp"

#include <fmod.hpp>

#include <string>

#define SPECTRUM_PRECISION 64

/**
 * Class managing a music by using FMOD Ex
 * Uses the Singleton pattern
 * @author Alexandre LAURENT
 */
class Music : public Utils::Singleton<Music>
{
	private:
		// FMOD variables to manage the music
		FMOD_SYSTEM* system;
		FMOD_SOUND* sound;
		FMOD_CHANNEL* channel;
	
	public:
		Music(void);
		~Music(void);	
		
		/**
		 * Initialise FMOD Ex
		 * @return bool false if something goes wrong
		 */
		bool create(void);
		
		/**
		 * Load the music file
		 * @param std::string& the file name
		 * @return bool false if something goes wrong
		 */
		bool loadFile(const std::string& filename);
		
		/**
		 * Play the music
		 */
		void play(void);
		
		/**
		 * Stop the music
		 */
		void stop(void);
		
		/**
		 * Update the system (for the callbacks evaluation)
		 */
		void update(void);
		
		/**
		 * Get the spectrum of the current music
		 * @param float* the array that will be filled with the spectrum values
		 * @param const unsigned int the precision of the spectrum
		 */
		void getSpectrum(float* spectrum, const unsigned int precision);
};

#endif
