#include "Music.hpp"

//#ifdef _DEBUG
	#include <iostream>
	#include <fmod_errors.h>
//#endif

#include "../Callbacks/Sound.hpp"

Music :: Music(void)
{	
	system = NULL;
	sound = NULL;
	channel = NULL;
	
#ifdef _DEBUG
	std::cout << "Music created" << std::endl;
#endif
}

Music :: ~Music(void)
{
	FMOD_Sound_Release(sound);
	FMOD_System_Release(system);
	
#ifdef _DEBUG
	std::cout << "Music deleted" << std::endl;
#endif
}

bool Music :: create(void)
{
	FMOD_RESULT result;
	
	result = FMOD_System_Create(&system);
	if ( result != FMOD_OK )
	{
		std::cerr << FMOD_ErrorString(result) << std::endl;
		return false;
	}
		
	result = FMOD_System_Init(system, 10, FMOD_INIT_NORMAL, NULL);
	if ( result != FMOD_OK )
	{
		std::cerr << FMOD_ErrorString(result) << std::endl;
		return false;
	}
	return true;
}

bool Music :: loadFile(const std::string& filename)
{
	FMOD_RESULT result;
	
	result = FMOD_System_CreateStream(system, filename.c_str(), FMOD_SOFTWARE | FMOD_LOOP_OFF | FMOD_2D, 0, &sound);
	if ( result != FMOD_OK )
	{
		std::cerr << FMOD_ErrorString(result) << std::endl;
		return false;
	}
	return true;
}

void Music :: play(void)
{
	FMOD_System_PlaySound(system, FMOD_CHANNEL_FREE, sound, 0, &channel);
	FMOD_Channel_SetCallback(channel, &callback::onEnd);
}

void Music :: stop(void)
{
	FMOD_Channel_Stop(channel);
}

void Music :: update(void)
{
	FMOD_System_Update(system);
}

void Music :: getSpectrum(float* spectrum, const unsigned int precision)
{
	FMOD_RESULT error =	FMOD_Channel_GetSpectrum(channel, spectrum, precision, 0, FMOD_DSP_FFT_WINDOW_TRIANGLE);
	if ( error != FMOD_OK )
		std::cerr << FMOD_ErrorString(error) << std::endl;
}

