#ifndef __SHADERLOADER_HPP__
#define __SHADERLOADER_HPP__

#include <fstream>
#include <string>

namespace Loader
{
	/**
	 * Get the size of the file passed to the function
	 * @param std::ifstream& the file
	 * @return unsigned long the size of the file
	 */
	unsigned long getFileSize(std::ifstream& file);
	
	/**
	 * Load a file into a array of string
	 * @param const std::string& the filename
	 * @param char** the array of string to fill
	 * @param int* the length of the file
	 * @return bool false if something goes wrong
	 */
	bool loadShader(const std::string& filename, char** shader, int* length);
}

#endif
