#include "ShaderLoader.hpp"

#include <fstream>
#include <iostream>

unsigned long Loader::getFileSize(std::ifstream& file)
{
	unsigned long initial_pos = file.tellg();	// Keep the current position
	file.seekg(0,std::ios_base::end);			// Go to the end
	unsigned long size = file.tellg();			// Get the current position
	file.seekg(initial_pos, std::ios_base::beg);	// Return to the initial position
	return size;
}

bool Loader::loadShader(const std::string& filename, char** shader, int* length)
{	
	std::ifstream file(filename.c_str(),std::ios::in);
	
	if ( !file.is_open() )
	{
		std::cerr << "Error during the opening of the file: " << filename << std::endl;
		file.close();
		return false;
	}
	
	*length = getFileSize(file);
	
	if ( *length == 0 )
	{
		std::cerr << "The file: " << filename << " is empty" << std::endl;
		file.close();
		return false;
	}
	
	*shader = new char[(*length)+1];
	if ( *shader == NULL )
	{
		std::cerr << "Error to allocate memory for the shader" << std::endl;
		file.close();
		return false;
	}
	
	// Must be 0 terminated
	(*shader)[*length] = 0;
	
	unsigned int i = 0;
	while ( file.good() )
	{
		(*shader)[i] = (char)file.get();
		if ( !file.eof() )
			i++;
	}
	
	// Must be 0 terminated (before the total length)
	(*shader)[i]=0;	
	
	file.close();
	
	return true;
}
