#ifndef __PSHADER_HPP__
#define __PSHADER_HPP__

#include <string>

/**
 * Class to load a program shader and to use it
 */
class PShader
{
#ifdef _DEBUG
	/**
 	 * Debug: enumerator of the current state of the class. 
	 * Used to debug quickly by asserting parts of the code
	 */
	enum PShaderState
	{
		NotAttached,
		NotLinked,
		Ready,
		InUse
	};
#endif
	
	private:
		unsigned int psId;	///< The OpenGL identifier of the program shader
#ifdef _DEBUG
		PShaderState state;	///< Debug: the current state of the class
#endif
		
	public:
		PShader(void);
		~PShader(void);
		
		/**
		 * Attach a shader to the program
		 * @param unsigned int the identifier of the shader to attach
		 */
		void attach(unsigned int shaderId);
		
		/**
		 * Detach a shader from the program
		 * @param unsigned int the identifier of the shader to detach
		 */
		void detach(unsigned int shaderId);
		
		/**
		 * Link the shaders to the program (OpenGL operation)
		 * @return bool if something goes wrong, return false
		 */
		bool link(void);
		
		/**
		 * Enable this program
		 */
		void use(void);
		
		/**
		 * Desable the use of a program
		 */
		void unuse(void);
		
		/**
		 * Get the identifier of an uniform variable
		 * @param const std::string& the name of the variable
		 * @return int the OpenGL identifier
		 */
		int getUniformId(const std::string& name)const;
		
		/**
		 * Get the identifier of an attrib variable
		 * @param const std::string& the name of the variable
		 * @return int the OpenGL identifier
		 */
		int getAttribId(const std::string& name)const;
};

#endif
