#ifndef __GLSHADER_HPP__
#define __GLSHADER_HPP__

#include <string>

/**
 * Class to load shaders and compile these
 */
class GLShader
{
	protected:
		unsigned int glShaderId;	///< The OpenGL shader identifier
#ifdef _DEBUG
		bool error;
#endif
	
	public:
		/**
		 * Load a file into the shader
		 * @param const std::string& the file name
		 * @return bool if something goes wrong ; returns false
		 */
		bool load(const std::string& filename);
		/**
		 * Compile the shader
		 * @return bool if something goes wrong ; return false
		 */
		bool compile(void);
	
		/**
		 * Get the OpenGL identifier of the shader
		 * @return unsigned int the identifier
		 */
		unsigned int getGLShaderId(void)const { return glShaderId; };
#ifdef _DEBUG
		bool getError(void)const { return error; };
#endif
		
		virtual ~GLShader(void);
};

#endif
