#include "GLShader.hpp"

#include <GL/glew.h>

#include "ShaderLoader.hpp"

#include <iostream>

GLShader :: ~GLShader(void)
{
	glDeleteShader(glShaderId);
#ifdef _DEBUG
	std::cerr << "Shader deleted" << std::endl;
#endif
}

bool GLShader :: load(const std::string& filename)
{
	char* shaderSource = NULL;
	int length;
	bool noError = true;
	
	noError = Loader::loadShader(filename, &shaderSource, &length);
	if ( noError )	// If the loading works
	{
		glShaderSource(glShaderId, 1, (const GLchar**)&shaderSource, &length);
	}
	
	delete []shaderSource;
	
	return noError;	
}

bool GLShader :: compile(void)
{
	GLint compilationStatus = GL_TRUE;
	
	glCompileShader(glShaderId);	
	
	glGetShaderiv(glShaderId, GL_COMPILE_STATUS, &compilationStatus);
	if ( compilationStatus != GL_TRUE )
	{
		std::cerr << "Error during the compilation of the shader" << std::endl;
		
		GLint errorStringSize = 0;
		char* errorString = NULL;
		
		glGetShaderiv(glShaderId, GL_INFO_LOG_LENGTH, &errorStringSize);
		
		errorString = new char[errorStringSize+1];
		if ( errorString == NULL )
		{
			std::cerr << "Error while allocating memory to get the log entry of OpenGL" << std::endl;
			return false;
		}
		
		glGetShaderInfoLog(glShaderId, errorStringSize, &errorStringSize, errorString);
		std::cerr << "=> " << errorString << std::endl;
		
		delete []errorString;
		return false;
	}
	std::cout << "Shader Compiled" << std::endl;
	return true;
}
