#ifndef __SCENE_HPP__
#define __SCENE_HPP__

#include "Utils/Singleton.hpp"

#include <vector>

class Camera;
class VShader;
class FShader;
class PShader;

class ParticleSystem;

/**
 * Scene class : gives a World to draw using OpenGL
 * Uses the singleton pattern
 * @author Alexandre LAURENT
 */
class Scene : public Utils::Singleton<Scene>
{
	private:		
		Camera* cam;			///< The Scene has a camera
	
		VShader* vertexShader;
		FShader* fSBlinking;
		PShader* programShader;
		
		float* musicSpectrum;
		
		std::vector<ParticleSystem*> particleSystems;

		bool readyToQuit;
		
		bool initGL(void);	///< Initialise OpenGL
	
	public:
		Scene(void);
		~Scene(void);
		
		/**
		 * Create the particle systems
		 * @const unsigned int maximum number of particles in the scene (= 500000)
		 */
		bool create(const unsigned int limitNbParticles = 500000);
	
		void draw();	///< Draw the scene
		
		/**
		 * Update the scene components
		 * @param const unsigned int the ellapsed time
		 */
		void update(const unsigned int time);	///< Update the Scene; know the ellapsed time
		
		Camera* getCamera(void)const { return cam; };	///< Return the camera used by the scene

		void setReadyToQuit(void) { readyToQuit = true; };	///< Flag to know if the program has terminate his tasks
};

#endif
