#ifndef __PARTICLESYSTEM_HPP__
#define __PARTICLESYSTEM_HPP__

#include "MemoryPool.hpp"
#include "Particle.hpp"

#include "../Math/Vertex3.hpp"

#include "../Utils/Tables.hpp"

#include <vector>

#define SEQUENCING	2

/**
 * ParticleSystem: do a firework
 * @author Alexandre LAURENT
 */
class ParticleSystem
{
	private:
		static const unsigned int yMin = 0;
		static const unsigned int yMax = 2;
	
		MemoryPool<Particle> particles;
		
		Math::Vertex3 emitterPosition;
		
		Math::Vertex3 gravity;
		unsigned int birthRate;
		unsigned int lastRefreshTime;
		unsigned int refreshTimeStep;
		
		bool directionY;
		
		Utils::Table randXZTable;
		Utils::Table randYTable;
		
		char sequencer;
		
		unsigned int index;
		
	public:
		/**
		 * ParticleSystem constructor
		 * @param const unsigned int the number of particles
		 * @param const Math::Vertex3& the position where the particles start
		 * @param const unsigned int the time between two update
		 * @param const bool the direction of the particles on the y axis
		 * @param const unsigned int index to keep the spectrum array index
		 */
		ParticleSystem(const unsigned int nbParticles, const Math::Vertex3& emitterPosition, const unsigned int refreshTimeStep, const bool directionY, const unsigned int index);
		~ParticleSystem(void);
	
		void draw(void);	///< Draw the ParticleSystem
		
		/**
		 * Update the ParticleSystem; based upon time
		 * @param const unsigned int ellapsed time
		 */
		void update(const unsigned int time);
		
		/**
		 * Return the number of particles displayed
		 * @return unsigned int the number of particles
		 */
		unsigned int getNbParticles(void)const { return particles.nbReady; };
		
		/**
		 * Set the birth rate of the particles
		 * @param const unsigned int the new birth rate
		 */
		void setBirthRate(const unsigned int newBirthRate);
		
		/**
		 * Get the index for the music spectrum
		 * @return unsigned int the index kept by the class
		 */
		unsigned int getIndex(void)const { return index; };
	
};

#endif
