#include "ParticleSystem.hpp"

#include "../Types/Colours.hpp"

#include <GL/freeglut.h>
#include <GL/gl.h>

#include <iostream>

ParticleSystem :: ParticleSystem(const unsigned int nbParticles, const Math::Vertex3& emitterPosition, const unsigned int refreshTimeStep, const bool directionY, const unsigned int index)
	:particles(nbParticles),emitterPosition(emitterPosition),birthRate(10),refreshTimeStep(refreshTimeStep),directionY(directionY),randXZTable(10000, -0.5f, 0.5f),randYTable(10000, 3, 6),sequencer(0),index(index)
{
	birthRate = 0;

	if ( directionY ) 
		gravity = Math::Vertex3( 0, 9.81f, 0 );
	else
		gravity = Math::Vertex3( 0, -9.81f, 0 );
	lastRefreshTime = 0;
	
	std::cout << "ParticleSystem created for " << nbParticles << " particles" << std::endl;
}

ParticleSystem :: ~ParticleSystem(void)
{
	std::cout << "ParticleSystem deleted" << std::endl;
}

/**
 * Optimised draw function, using the OpenGL arrays
 */

void ParticleSystem :: draw()
{	
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);

	glColorPointer(3, GL_FLOAT, sizeof(Particle), &particles.pool[0].colour);
	glVertexPointer(3, GL_FLOAT, sizeof(Particle), &particles.pool[0].position);
	glDrawArrays(GL_POINTS, 0, particles.nbReady);
	
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_VERTEX_ARRAY);
}

void ParticleSystem :: update(const unsigned int time)
{
	while ( time - lastRefreshTime > refreshTimeStep )
	{
		float h = refreshTimeStep/1000.0f;
		Math::Vertex3 gravity_mul_h = gravity * h;
		
		// Birth
		for ( unsigned int i = 0 ; i < birthRate ; ++i )
		{
			int number = particles.emitElem();
			if ( number != -1 )
			{
				if ( directionY )
					particles.pool[number] = Particle(emitterPosition, Math::Vertex3(randXZTable.getElement(), -randYTable.getElement(), randXZTable.getElement()), Colour3(1,1,1));
				else
					particles.pool[number] = Particle(emitterPosition, Math::Vertex3(randXZTable.getElement(), randYTable.getElement(), randXZTable.getElement()), Colour3(1,1,1));
			}
		}
		
		for ( unsigned int i = sequencer ; i < particles.nbReady ; i += SEQUENCING )
		{			
			// update PS
				// - Position
			particles.pool[i].position = particles.pool[i].position + particles.pool[i].velocity * h + gravity_mul_h*h*0.5f;
				// - Velocity
			particles.pool[i].velocity = particles.pool[i].velocity + gravity_mul_h;	
		
		
			if ( directionY )
			{
				if ( particles.pool[i].position.y > yMax )
					particles.killElem(i);
			}
			else
			{
				if ( particles.pool[i].position.y < yMin )
					particles.killElem(i);
			}
		
		}
		
		// Update the local time
		lastRefreshTime += refreshTimeStep;
		
		// Change the sequencer to update the other particle the next time
		sequencer++;
		if ( sequencer == SEQUENCING )
			sequencer = 0;
	}
}

void ParticleSystem :: setBirthRate(const unsigned int newBirthRate)
{
	birthRate = newBirthRate;
}

