#ifndef __PARTICLE_HPP__
#define __PARTICLE_HPP__

#include "../Math/Vertex3.hpp"
#include "../Types/Colours.hpp"

typedef struct Particle
{
	Math::Vertex3 position;
	Math::Vertex3 velocity;
	
	Colour3 colour;	

	Particle()	:position(),
				velocity(),
				colour(){};
				
	Particle(const Math::Vertex3 position, 
			 const Math::Vertex3 velocity, 
			 const Colour3 colour)
			 		:position(position),
					velocity(velocity),
					colour(colour){};
}Particle;

#endif
