#ifndef __MEMORYPOOL_HPP__
#define __MEMORYPOOL_HPP__

#include <vector>

/**
 *	MemoryPool structure: Template to manage a pool of data
 *  Will create a container with a fixed size and manage the data inside
 *	@author Alexandre LAURENT
 */
template <typename T>
struct MemoryPool
{
	std::vector<T> pool;
	unsigned int nbReady;

	/**
	 * MemoryPool constructor: set the container
	 * @param const unsigned int maximum number of elements
	 */
	MemoryPool(const unsigned int nbMaxElem);

	/**
	 *	Delete an element (place to the end of the pool)
	 *  @param const unsigned int index of the element to delete
	 */
	void killElem(const unsigned int index);

	/**
	 *	Return the index of an element ready to use
	 *  @return int the index of the element ready to use or -1 if no more element can be used
	 */
	int emitElem(void);

};

#include "MemoryPool.cpp"

#endif
