#ifndef __MEMORYPOOL_CPP__
#define __MEMORYPOOL_CPP__

#include "MemoryPool.hpp"

#include <cassert>

template <typename T>
MemoryPool<T>::MemoryPool(const unsigned int nbMaxElem)
{
	pool.resize(nbMaxElem);
	nbReady = 0;
}

template <typename T>
void MemoryPool<T>::killElem(const unsigned int index)
{
	assert(index < nbReady);	// Can delete an element not used
			
	// Swap the element to delete with the last 'correct' element
	T temp = pool[index];

	nbReady--;
	pool[index] = pool[nbReady];
	pool[nbReady] = temp;
}

template <typename T>
int MemoryPool<T>::emitElem(void)
{
	if ( nbReady < pool.size()-1 )
	{
		nbReady++;
		return nbReady-1;
	}
	return -1;
}

#endif
