#ifndef __VERTEX3_HPP__
#define __VERTEX3_HPP__

namespace Math
{
	/**
	 * Structure for the vertex in 3 dimensions world
	 */
	typedef struct Vertex3
	{
		float x;
		float y;
		float z;

		Vertex3(void):x(0),y(0),z(0){};
		
		/**
		 * Vertex3 Constructor
		 * @param const float the x coordinate
		 * @param const float the y coordinate
		 * @param const float the z coordinate
		 */
		Vertex3(const float x, const float y, const float z):x(x),y(y),z(z) {};
		
		/**
		 * Vertex3 addition operator
		 * @param const Vertex3& the vector to add to the current
		 */
		Vertex3 operator+ (const Vertex3& v)const;
		
		/**
		 * Vertex3 subtraction operator
		 * @param const Vertex3& the vector to subtract to the current
		 */
		Vertex3 operator- (const Vertex3& v)const;
		
		/**
		 * Vertex3 multiplication operator
		 * @param const float the coef to multiply to the current vector
		 */
		Vertex3 operator* (const float coef)const;
		
		/**
		 * Vertex3 multiplication operator
		 * @param const const Vertex3& the coef to multiply to the current vector
		 */
		Vertex3 operator* (const Vertex3& v)const;
		
		/**
		 * Vertex3 division operator
		 * @param const float the coef to divide to the current vector
		 */
		Vertex3 operator/ (const float coef)const;
		
		/**
		 * Vertex3 division operator
		 * @param const Vertex3& the coef to divide to the current vector
		 */
		Vertex3 operator/ (const Vertex3& v)const;
		
		/**
		 * Vertex3 cross product
		 * @param const Vertex3& the vertex to cross with the current
		 */
		Vertex3 cross(const Vertex3& v)const;
		
		/**
		 * Vertex3 dot product
		 * @param const Vertex3& the vertex to dot with the current
		 */
		float dot(const Vertex3& v)const;
		
		/**
		 * Vertex3 length
		 */
		float length(void)const;
		
		/**
		 * Vertex3 normalisation
		 */
		Vertex3 normalise(void);
	}Vertex3;
}

#endif
