#include "Vertex3.hpp"

#include <cmath>

Math::Vertex3 Math::Vertex3 :: operator+ (const Vertex3& v)const
{
	return Math::Vertex3 ( this->x + v.x , this->y + v.y , this->z + v.z );
}

Math::Vertex3 Math::Vertex3 :: operator- (const Vertex3& v)const
{
	return Math::Vertex3 ( this->x - v.x , this->y - v.y , this->z - v.z );
}

Math::Vertex3 Math::Vertex3 :: operator* (const float coef)const
{
	return Math::Vertex3( this->x * coef, this->y * coef, this->z * coef);
}

Math::Vertex3 Math::Vertex3::operator* (const Vertex3& v)const
{
	return Math::Vertex3( this->x * v.x , this->y * v.y , this->z * v.z);
}

Math::Vertex3 Math::Vertex3 :: operator/ (const float coef)const
{
	return Math::Vertex3( this->x / coef, this->y / coef, this->z / coef);
}

Math::Vertex3 Math::Vertex3 :: operator/ (const Vertex3& v)const
{
	return Math::Vertex3( this->x / v.x, this->y / v.y, this->z /v.z);
}

Math::Vertex3 Math::Vertex3 :: cross(const Vertex3& v)const
{
	return Math::Vertex3( this->y * v.z - this->z * v.y,
							this->z * v.x - this->x * v.z,
							this->x * v.y - this->y * v.x);
}

float Math::Vertex3 :: dot(const Vertex3& v)const
{
	return (this->x * v.x + this->y * v.y + this->z * v.z);
}

Math::Vertex3 Math::Vertex3::normalise(void)
{
	float l = this->length();
	
	return Math::Vertex3(this->x / l, this->y / l, this->z / l);
}

float Math::Vertex3::length(void)const
{
	return sqrt( this->x * this->x + this->y * this->y + this->z * this->z );
}
