#ifndef __CAMERA_HPP__
#define __CAMERA_HPP__

#include "../Math/Vertex3.hpp"

/**
 * Class Camera: Inspection camera
 * @author Alexandre LAURENT
 */
class Camera
{
	private:
		// Some variables
		static const int cameraSpeed = 1;
		static const int limitInclination = 80;
		static const int limitZoom = 5;
		static const int limitUnZoom = 15;
	
		Math::Vertex3 look;	///< The point of interest
		
		// Some variables determining the position
		float inclination;
		float rotation;
		float distance;	
	public:	
		Camera(const Math::Vertex3 look = Math::Vertex3(), const float inclination = 45, const float rotation = 0, const float distance = 15);
		~Camera(void);
		
		void apply(void);	///< Apply the camera to the OpenGL scene
		
		/**
		 * Move the camera by changing the inclination
		 * @param const bool if the camera must up or down
		 */
		void changeInclination(const bool up);
		
		/**
		 * Move the camera by changing the rotation angle
		 * @param const bool if the camera must go on the right or on the left
		 */
		void changeRotation(const bool right);
		
		/**
		 * Move the camera by changing the distance to the interest point
		 * @param const bool if the camera must zoom or unzoom
		 */
		void changeDistance(const bool zoom);
		
		/**
		 * Return the distance between the camera and the interest point
		 * @return float the distance between the camera and the interest point
		 */
		float getDistance(void)const { return distance; };
};

#endif
