#include "Camera.hpp"

#include "../Utils/Math.hpp"

#include <GL/freeglut.h>
#include <GL/glu.h>

#ifdef _DEBUG
	#include <iostream>
#endif

Camera :: Camera(const Math::Vertex3 look/* = Vertex3()*/, const float inclination/* = 45*/, const float rotation/* = 0*/, const float distance/* = 15*/)
		:look(look),inclination(inclination),rotation(rotation),distance(distance)
{	
#ifdef _DEBUG
	std::cout << "Camera created" << std::endl;
#endif
}

Camera :: ~Camera(void)
{
#ifdef _DEBUG
	std::cout << "Camera deleted" << std::endl;
#endif
}

void Camera :: apply(void)
{
	float sinRotation = Utils::sinDegreeAngle(rotation);
	float cosRotation = Utils::cosDegreeAngle(rotation);

	float cosInclination = Utils::cosDegreeAngle(inclination);
	float sinInclination = Utils::sinDegreeAngle(inclination);
	
	gluLookAt(	sinRotation * cosInclination * distance + look.x , sinInclination * distance + look.y , cosRotation * cosInclination * distance + look.z,
				look.x, look.y, look.z,
				0, 1, 0 );
}

void Camera :: changeInclination(const bool up)
{
	if ( up )
	{
		if ( inclination < limitInclination )
			inclination += cameraSpeed;
	}
	else
		if ( inclination > -limitInclination )
			inclination -= cameraSpeed;		
}

void Camera :: changeRotation(const bool right)
{
	if ( right )
	{
		rotation += cameraSpeed;
	}
	else
		rotation -= cameraSpeed;
}

void Camera :: changeDistance(const bool zoom)
{
	if ( zoom )
	{
		if ( distance > limitZoom )
			distance -= cameraSpeed/10.0f;
	}
	else
		if ( distance < limitUnZoom )
			distance += cameraSpeed/10.0f;
	
}
