#include "Keyboard.hpp"

#include "../Scene.hpp"
#include "../Camera/Camera.hpp"

#include <GL/freeglut.h>

#ifdef _DEBUG
	#include <iostream>
#endif

void callback :: keyboard(unsigned char key, int x, int y)
{
	// Remove warning about unused variables
	x=x;
	y=y;
	switch ( key )
	{
		case 27:	// Escape
			glutLeaveMainLoop();
			break;
		case 119:	// Z
			(Scene::getInstance()).getCamera()->changeInclination(true);
			break;
		case 115:	// W
			(Scene::getInstance()).getCamera()->changeInclination(false);
			break;
		case 100:	// D
			(Scene::getInstance()).getCamera()->changeRotation(true);
			break;
		case 97:	// A
			(Scene::getInstance()).getCamera()->changeRotation(false);
			break;
		case 113:	// Q
			(Scene::getInstance()).getCamera()->changeDistance(true);
			break;
		case 122:	// Z
			(Scene::getInstance()).getCamera()->changeDistance(false);
			break;
#ifdef _DEBUG
		default:
			std::cout << "Unknown key pressed: " << (int)key << std::endl;
			break;
#endif
	}
}
