#ifndef __WINDOWS_HPP__
#define __WINDOWS_HPP__

//void refresh(int value);
/**
 * Window class : gives a window to display the OpenGL Scene
 * @author Alexandre LAURENT
 */
class Window
{
	private:
	
		unsigned short int width;
		unsigned short int height;
		int window_id;
		
	public :
	
		Window(const char* window_name, int argc, char** argv, const short int pos_x=0, const short int pos_y=0, const unsigned short int width=800, const unsigned short int height=600);
		void initGL();		///< Inits the OpenGL state
		void handlingFuntion(void (*displayFunc)(void), void (*keyboardFunc) ( unsigned char , int , int ), void (*mouseEvent) ( int, int, int, int));		///< Sets the callback functions
		~Window();
		
		int getWindowID() { return window_id; };	///< Getter for the window ID
};

#endif
