#ifndef __SON_HPP__
#define __SON_HPP__

#include <vector>

#include <FMOD/fmod.h>

/**
 * class Son : gives the sound to the program ( using FMOD )
 * Uses the Singleton pattern
 * @author Alexandre LAURENT
 */
class Son
{
	private :
	
		std::vector <FMUSIC_MODULE*> musics;
		//FSOUND_STREAM* stream;
		static Son *sing_son;
		
		Son();
		~Son();
	
	public :
	
		static Son* getSon();		///< Gets an instance ( Singleton pattern )
		char loadMusic(char* , char );	///< Loads a music
		char playSong(unsigned int id_musique);	///< Plays a music
		float* getSpectrum() { return FSOUND_DSP_GetSpectrum(); };	///< Gets the spectrum of the music
		unsigned char getVolume();	///< Gets the current volume
		void setVolume(unsigned char volume);	///< Sets the current volume
		
		static void destroySon();	///< Deletes the instance of the Son ( Singleton pattern )
	
	
};

#endif
