#include "screen_selector.hpp"

#include "window.hpp"
#include "keyboard.hpp"
#include "time_manager.hpp"

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include <iostream>

#define NB_MENU	7

int window = 0;

/**
	Draws some text
	@param char* the text to draw
	@param int the position on the x axis
	@param int the position on the y axis
	@param bool is a big font
*/
void draw_text(char* text , int start_x, int start_y, bool big_font)
{
	int sum = 0;
	
	for ( unsigned int i = 0 ; i < strlen(text) ; i++ )
	{
		//glRasterPos2i( start_x  + ( i *  ) , start_y);
		
		if ( big_font )
		{
			glRasterPos2i( start_x  + sum   , start_y);
			glutBitmapCharacter( GLUT_BITMAP_TIMES_ROMAN_24 ,text[i]);
			sum += glutBitmapWidth( GLUT_BITMAP_TIMES_ROMAN_24 , text[i]);
		}
		else
		{
			glRasterPos2i( start_x  + sum   , start_y);
			glutBitmapCharacter( GLUT_BITMAP_9_BY_15 ,text[i]);
			sum += glutBitmapWidth( GLUT_BITMAP_9_BY_15 , text[i]);
		}
	}
}

/**
	Calculates the size of the text
	@param char* the text that we have to know the size
	@param bool is a big font
	@param int the width
*/
int calcsize_text( char* text, bool big_font )
{
	int sum=0;
	
	for ( unsigned int i = 0 ; i < strlen(text) ; i ++ )	
	{
		if ( big_font )
			sum += glutBitmapWidth( GLUT_BITMAP_TIMES_ROMAN_24 , text[i]);
		else
			sum += glutBitmapWidth( GLUT_BITMAP_9_BY_15 , text[i]);
	}
	
	return sum;
}

/**
	Function to draw the screen selection and to manage the animations inside
*/
void screen_selector_drawGL()
{
	char titre[] = "Resolution Selector";
	char titre2[] = "for Stars by LittleWhite";
	static bool titre_select = true;
	
	static int x_screen = glutGet(GLUT_SCREEN_WIDTH);
	static int y_screen = glutGet(GLUT_SCREEN_HEIGHT);
	static double ratio = x_screen / y_screen;
	std::cout << "ratio : " << ratio << std::endl;
	/*
	if ( ratio == 4/3.0 )
	{
		static char menu1[] = "640x480";
		static char menu2[] = "800x600";
		static char menu3[] = "1024x768";
		static char menu4[] = "1280x800";
	}
	else if ( ratio == 16/9.0 )
	{
		static char menu1[] = "640x480";
		static char menu2[] = "800x600";
		static char menu3[] = "1024x768";
		static char menu4[] = "1280x720";
	}
	else if ( ratio == 16/10.0 )
	{*/
		static char menu1[] = "640x480";
		static char menu2[] = "800x600";
		static char menu3[] = "1024x768";
		static char menu4[] = "1280x800";
	//} 
	
	char fullscreen_text[] = "Fullscreen mode disabled";
	
	if ( fullscreen )
		strcpy(fullscreen_text , "Fullscreen mode enabled ");
	
	static char start_button[] = "Demo";
	static char kill_button[] = "Die";
	static char position_carre = 3;
	static char position_carre2 = 2;
	static char position_carre3 = 1;
	static bool direction_carre = true;
	
	
	static char caract = 1;	
	static char refresh = 0;
	
	static short unsigned int tempo = 0;
	
	int x = glutGet(GLUT_WINDOW_WIDTH);
	int y = glutGet(GLUT_WINDOW_HEIGHT);
	
	int size_y = (glutGet(GLUT_WINDOW_HEIGHT)-(NB_MENU*10+20))/NB_MENU;
	
	bool big = false;
	
	if ( refresh == 20 )
	{
		if ( titre_select )
		{
			titre[(int)caract] = '\0';
			glutSetWindowTitle(titre);
		}
		else
		{
			titre2[(int)caract] = '\0';
			glutSetWindowTitle(titre2);
		}
		refresh=0;
		caract++;
			if ( titre_select )
			{
				if ( caract == 20 )
				{
					
					caract = 1;
					titre_select = ! titre_select;
				}
			}
			else
			{
				if ( caract == 25 )
				{
					caract = 1;
					titre_select = ! titre_select;
				}
			}
	}
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
    glLoadIdentity();
	
	glMatrixMode(GL_MODELVIEW);
    
    glDisable(GL_DEPTH_TEST);
   
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glPushMatrix();
    gluOrtho2D(0.0, x, 0.0, y);		// Make a parallel "scene" at the size of screen
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glPushMatrix();
    
    //glRasterPos2i(0,0);
    
    glBegin(GL_LINES);
    { 
    	for ( int j = 0 ; j < NB_MENU ; j++ )	
    	{
    		glColor3ub(255,255,255);
    		for ( int i = 0 ; i < size_y ; i ++ )
    		{
    			if ( j == ((NB_MENU-1)-resolution) )
    				glColor3ub(255,255/(j+1),0);
    			glVertex2d(30, (15+(j*10))+i+(size_y*j));
    			if ( j == ((NB_MENU-1)-resolution) )
	    			glColor3ub(0,255,255/(j+1));
    			glVertex2d(x-30, (15+(j*10))+i+(size_y*j));
    		}
		}
    }
    glEnd();
    
    glColor3ub(0,64,255);
    
    if ( size_y > 30 )
    	big = true;
    else
    	big=false;
    
   	draw_text(menu1, (x/2) - (calcsize_text(menu1, big)/2) ,y-26-size_y/2, big);
   	
   	draw_text(menu2, (x/2) - (calcsize_text(menu2, big)/2) ,y-21-size_y/2-15-size_y, big);
   	
   	draw_text(menu3, (x/2) - (calcsize_text(menu3, big)/2) ,y-16-size_y/2-30-2*size_y, big);
   	
   	draw_text(menu4, (x/2) - (calcsize_text(menu4, big)/2) ,y-11-size_y/2-45-3*size_y, big);
   	
   	draw_text(fullscreen_text, (x/2) - (calcsize_text(fullscreen_text, big)/2) ,y-6-size_y/2-60-4*size_y, big);
   	
   	draw_text(start_button, (x/2) - (calcsize_text(start_button, big)/2) ,y-1-size_y/2-75-5*size_y, big);
   	
   	glColor3ub(255,64,0);
   	
   	draw_text(kill_button, (x/2) - (calcsize_text(kill_button, big)/2) ,y+4-size_y/2-90-6*size_y, big);
   	
   	
   	
   	glBegin(GL_QUADS);
   	{
   		glColor3ub(0,128,255 );
   		
   		glVertex2d( 5 , (y/5)*position_carre  );
   		glVertex2d( 25 , (y/5)*position_carre  );
   		glVertex2d( 25 , (y/5)*(position_carre+1)  );
   		glVertex2d( 5 ,  (y/5)*(position_carre+1) );
   		
   		glVertex2d( x-5 , (y/5)*(5-position_carre)  );
   		glVertex2d( x-25 , (y/5)*(5-position_carre)  );
   		glVertex2d( x-25 , (y/5)*(5-(position_carre+1))  );
   		glVertex2d( x-5 ,  (y/5)*(5-(position_carre+1)) );
   		
   		glColor3ub(0,64,200 );
   		
   		glVertex2d( 5 , (y/5)*position_carre2  );
   		glVertex2d( 25 , (y/5)*position_carre2  );
   		glVertex2d( 25 , (y/5)*(position_carre2+1)  );
   		glVertex2d( 5 ,  (y/5)*(position_carre2+1) );
   		
   		glVertex2d( x-5 , (y/5)*(5-position_carre2)  );
   		glVertex2d( x-25 , (y/5)*(5-position_carre2)  );
   		glVertex2d( x-25 , (y/5)*(5-(position_carre2+1))  );
   		glVertex2d( x-5 ,  (y/5)*(5-(position_carre2+1)) );
   		
   		glColor3ub(0,32,150 );
   		
   		glVertex2d( 5 , (y/5)*position_carre3  );
   		glVertex2d( 25 , (y/5)*position_carre3  );
   		glVertex2d( 25 , (y/5)*(position_carre3+1)  );
   		glVertex2d( 5 ,  (y/5)*(position_carre3+1) );
   		
   		glVertex2d( x-5 , (y/5)*(5-position_carre3)  );
   		glVertex2d( x-25 , (y/5)*(5-position_carre3)  );
   		glVertex2d( x-25 , (y/5)*(5-(position_carre3+1))  );
   		glVertex2d( x-5 ,  (y/5)*(5-(position_carre3+1)) );
   		
	}glEnd();
    
    glEnable(GL_DEPTH_TEST);
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
    glMatrixMode(GL_PROJECTION);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
    
    if ( tempo % 10 == 0 )
    {
    	position_carre3 = position_carre2;
    	position_carre2 = position_carre;
    
    	if ( direction_carre )
	    	position_carre++;
    	else
    		position_carre--;
    	if ( position_carre == -1 || position_carre == 6 )
    		direction_carre = ! direction_carre;
	}
	tempo++;
    	
    
    
    glutSwapBuffers();
    
    timer.countFPS();
	timer.waitForFPS();
	
	refresh++;
	
}

/**
	Start the screen selector
*/
void start()
{
	Window* screen_selector_window = new Window("Resolution Selector", 0, NULL, -1, -1, 350, 200);
	
	screen_selector_window->initGL();
	
	screen_selector_window->handlingFuntion(&screen_selector_drawGL , &keyboardEvent, &mouseEvent);
	
	window = screen_selector_window->getWindowID();
	
	glDisable(GL_LIGHTING);
	
	glutMainLoop();
}
