#include "scene2.hpp"
#include "draw_stuff.hpp"

#include <GL/gl.h>
#include <GL/glu.h>

#include <math.h>

GLuint obj_Scene2;

/**
	Initialises the second scene
	Uses the OpenGL list
*/
void initScene2()
{
	obj_Scene2 = glGenLists(1);
	
	glNewList(obj_Scene2, GL_COMPILE);
	{
		GLUquadric *paramQua = gluNewQuadric();
		gluQuadricDrawStyle(paramQua,GLU_LINE);
		
		for ( float i = -5 ; i < 5 ; i+=1.5 )
		{
			for ( float j = -5 ; j < 5 ; j+=1.5 )
			{
				for ( float k = -5 ; k < 5 ; k+=1.5 )
				{
					glPushMatrix();
					glTranslated( i , j , k );
					glColor3f ( 1-(fabs(i)/12.5), 1-(fabs(j)/12.5), 1-(fabs(k)/12.5) );
					drawCube(0.25, 0.25, 0.25, false);
					glPushMatrix();
					gluCylinder(paramQua, 0.1 , 0.1 , 1.5 , 10 , 10 );
					glRotated( 90 , 1 , 0 , 0 );
					gluCylinder(paramQua, 0.1 , 0.1 , 1.5 , 10 , 10 );
					glRotated( 90 , 0 , 1 , 0 );
					gluCylinder(paramQua, 0.1 , 0.1 , 1.5 , 10 , 10 );
					glPopMatrix();
					glPopMatrix();
				}
			}
		}
	}glEndList();
}

/**
	Initialises the second scene ( second configuration )
	Uses the OpenGL list
*/
void initScene2s()
{
	obj_Scene2 = glGenLists(1);
	
	glNewList(obj_Scene2, GL_COMPILE);
	{
		GLUquadric *paramQua = gluNewQuadric();
		gluQuadricDrawStyle(paramQua,GLU_LINE);
		
		for ( float i = -5 ; i < 5 ; i+=1.5 )
		{
			for ( float j = -5 ; j < 5 ; j+=1.5 )
			{
				for ( float k = -5 ; k < 5 ; k+=1.5 )
				{
					glPushMatrix();
					glTranslated( i , j , k );
					glColor3f ( 1-(fabs(i)/12.5), 1-(fabs(j)/12.5), 1-(fabs(k)/12.5) );
					glBegin(GL_LINES);
					{
						glVertex3f( 0.25 , 0.25 , 0.25 );
						glVertex3f( 0.25 , 0.25, -0.25 );
						
						glVertex3f( 0.25 , 0.25, -0.25 );
						glVertex3f( -0.25 , 0.25, -0.25 );
						
						glVertex3f( -0.25 , 0.25, -0.25 );
						glVertex3f( -0.25 , 0.25, 0.25 );
						
						glVertex3f( -0.25 , 0.25, 0.25 );
						glVertex3f( 0.25 , 0.25, 0.25 );
						
				
						glVertex3f( 0.25 , 0.25, 0.25 );
						glVertex3f( 0.25 , -0.25, 0.25 );
						
						glVertex3f( 0.25 , -0.25, 0.25 );
						glVertex3f( 0.25 , -0.25, -0.25 );
						
						glVertex3f( 0.25 , -0.25, -0.25 );
						glVertex3f( 0.25 , 0.25, -0.25 );
						
						glVertex3f( -0.25 , -0.25, -0.25 );
						glVertex3f( -0.25 , -0.25, 0.25 );
						
						glVertex3f( -0.25 , -0.25, 0.25 );
						glVertex3f( -0.25 , 0.25, 0.25 );
						
						glVertex3f( -0.25 , -0.25, -0.25 );
						glVertex3f( -0.25 , 0.25, -0.25 );
						
						
						glVertex3f( -0.25 , -0.25, 0.25 );
						glVertex3f( 0.25 , -0.25, 0.25 );
						
						glVertex3f( -0.25 , -0.25, -0.25 );
						glVertex3f( 0.25 , -0.25, -0.25 );
					}glEnd();
					
					
					//drawCube(0.25, 0.25, 0.25, false);
					glPushMatrix();
					gluCylinder(paramQua, 0.1 , 0.1 , 1.5 , 2 , 2 );
					glRotated( 90 , 1 , 0 , 0 );
					gluCylinder(paramQua, 0.1 , 0.1 , 1.5 , 2 , 2 );
					glRotated( 90 , 0 , 1 , 0 );
					gluCylinder(paramQua, 0.1 , 0.1 , 1.5 , 2 , 2 );
					glPopMatrix();
					glPopMatrix();
				}
			}
		}
	}glEndList();
}

/**
	Draw the scene
	Uses the OpenGL list
*/
void drawScene2()
{
	glCallList(obj_Scene2);
}

/**
	Deletes the scene
	Uses the OpenGL list
*/
void deleteScene2()
{
	glDeleteLists(obj_Scene2, 1);
}
