#include "keyboard.hpp"
#include "draw_stuff.hpp"
#include "demo.hpp"
#include "star.hpp"

#include <GL/glut.h>

int resolution = 2;
bool fullscreen = true;

int resolution_x = 1024;
int resolution_y = 768;

#include <iostream>

/**
	Function to handle the events from the keyboard
	@param unsigned char key : the key pressed
	@param int x : mouse position on the x axis
	@param int y : mouse position on the y axis
*/
void keyboardEvent(unsigned char key, int x, int y)
{	
	if ( key == 27 )
	{
		deleteStars();
		exit(0);
	}
}

/**
	Function to handle the events from the keyboard
	@param int button : the button used
	@param int sate : if the button is released or down
	@param int x : mouse position on the x axis
	@param int y : mouse position on the y axis
*/
void mouseEvent(int button, int state, int x, int y )
{
	if ( button == GLUT_LEFT_BUTTON )
	{
		if ( state == GLUT_UP )
		{			
			int size_y = (glutGet(GLUT_WINDOW_HEIGHT)-(7*10+20))/7;
			int selection = -1;
	
			for ( int j = 0 ; j < 7 ; j++ )
				if ( y > (15+(j*10))+(size_y*j) && y < ((20+(j*10))+(size_y*j)+size_y) && x > 30 && x < (glutGet(GLUT_WINDOW_WIDTH)-30))
					selection = j;
			
			if ( selection != -1 && selection < 4 )
				resolution = selection ;
			else if ( selection == 4 )
				fullscreen = !fullscreen;
			else if ( selection == 5 ) //demo ...
			{
				switch( resolution )
				{
					case 0 : resolution_x = 640;
							resolution_y = 480;
							break;
					case 1 : resolution_x = 800;
								resolution_y = 600;
								break;
					case 2 : resolution_x = 1024;
								resolution_y = 768;
								break;
					case 3 : resolution_x = 1280;
								resolution_y = 800;
								break;
					
				}
				glutDestroyWindow(window);
				
				demo();
			}
			if ( selection == 6 )	// You miss certainly something
				exit(0);			
		}
	}
}
