#include "World_Entities.hpp"

#include "World.hpp"
#include "Visualisation.hpp"
#include "Sound.hpp"

#include "Position.hpp"
#include "Interpolation.hpp"

/**
	World_Entities's constructor
	@param const Position& initial_pos : the initial position of the element
	@param unsigned char type : the type
*/
World_Entities :: World_Entities(const Position& initial_pos, const unsigned char type):	old_pos(initial_pos),
																					pos(initial_pos),
																					texture(-1),
																					isAnimation(false),
																					animation_counter(0),
																					state(EntitiesState::NORMAL),
																					type(type),
																					life(0)
{	
	texture = World::getWorld()->getIdSprite(type);	// Gives the sprite
	(blackbox::Sound::getSound())->playSound(World::getWorld()->getIdSound(type),0,950);	// Gives the sound
}

/**
	Function to update the elements into the word
	Conceptually just update the Position ( the next become the last, and we calculate the new Position )
*/
void World_Entities::update(void)
{
	old_pos = pos;
	this->move();	// pos will be modified
}

/**
	Function to draw the element
	First interpolate the position to have a linear movement
*/
void World_Entities::draw(void)
{
	if ( life >= 0 ) // To draw only the living objects
	{
		Position real_pos = interpolate(old_pos,pos);

		if ( isAnimation )	// Draw animated sprite
			(Visualisation::getVisualisation())->drawAnimation(texture,real_pos.x,real_pos.y,&animation_counter,&animation_time,75);
		else	// Draw non animated sprite
			(Visualisation::getVisualisation())->drawTexture(texture, real_pos.x, real_pos.y);
	}
}

/**
	Function to make some damage on the object
	Can add explosion into the World
	@param const unsigned int damage : the damage
	@return bool : if the entity is destroyed
*/
bool World_Entities :: setDamage(const unsigned int damage)
{
	life -= damage+1;
	if ( life < 0 )
	{
		if ( type < EntitiesType::BULLET1 )
			(World::getWorld())->addExplosion(EntitiesType::EXPLOSION2,pos);
		
		(World::getWorld())->deleteElement(this);
		return true;
	}
	return false;
}
