#ifndef __WORLD_HPP__
#define __WORLD_HPP__

#include <vector>
#include "UI.hpp"
#include "Level.hpp"


class World_Entities;
class Background;
struct Position;


class World
{
	private :
		std::vector<World_Entities*> objects;
		std::vector<World_Entities*> trash;	// The unused objects ( bullets out of screen ... ) will be placed here for deletion at the end of the level ( or game )

		static World* world;

		World(const unsigned char difficulty);
		~World();

		// Time for the interpolation
		int last_time;
		int next_time;

		// Background
		Background* background;

		// User Interface
		UI* ui;

		// Level
		unsigned char level_number;
		Level* level;

		// Game play
		int score;
		int highscore;

		unsigned char difficulty;

		unsigned int wait_time;	// Time to wait when we must go back to the menu

		bool win;
		bool lose;

		// List of identifier for the sprites
		std::vector<int> sprites_ids;

		// List of identifier for the sounds
		std::vector<int> sounds_ids;

		// To add an object ( like a factory ? )
		void addObject(const unsigned char type, const Position& initial_pos);

		/* To add just an enemy 
			( Friend for the Level, to give an access limited to the level , 
			and I use a new function just for not give a too big access -> because If a give an access to addObject, Level can create other objects )
		*/
		void addEnemy(const unsigned char type, const Position& initial_pos);

		friend bool Level :: update(void);

	public :
		static World* getWorld(const unsigned char difficulty = 1);
		void destroyWorld(void);

		bool draw(void);
		void update(void);

		int getIdSprite(const unsigned char id)const;
		int getIdSound(const unsigned char id)const;
		int getScore(void)const { return score; };
		int getHighScore(void)const { return highscore; };
		unsigned char getDifficulty(void)const { return difficulty; };
		unsigned int getEnemiesNumber(void)const;
		bool getPlayerIsAlive(void)const;
		unsigned int getPLayerLife(void)const;

		// We update the time for the interpolation
		void updateTime(void);

		// To get the key time
		unsigned int getLastTime(void)const { return last_time; };
		unsigned int getNextTime(void)const { return next_time; };

		// To add an explosion
		void addExplosion(const unsigned char type, const Position& position);

		// To add a bullet
		void addBullet(const unsigned char type, const Position& position, const int dx, const int dy);

		// Manage the Trash
		void emptyTrash(void);
		void deleteElement(const World_Entities* elem);

		// Manage the collisions
		void doCollision(void);

		// To load a level
		void loadLevel(void);

		// To increase the score
		void increaseScore(const unsigned char type);

};

#endif
