#ifndef __TEXTURE_HPP__
#define __TEXTURE_HPP__

#include "global.hpp"
#include "Colour.hpp"

#ifdef _SDL
	#include <SDL/SDL.h>
#endif

#include <string>

using namespace std;

class Texture
{
	private :
	
		#ifdef _SDL
			SDL_Surface* data;
		#endif
		#ifdef _HAPI
			unsigned char* data;
			bool alpha;
		#endif
		
		unsigned int width;
		unsigned int height;
		
		bool setAlphaColour(const blackbox::TColour&);
		
	public:
	
		Texture(const string& name);
		Texture(const string& name, const blackbox::TColour&);
		
		#ifdef _HAPI
			Texture(const unsigned char* data, const int width, const int height);
			Texture(const unsigned char* data, const int width, const int height,const blackbox::TColour& transparancy);
		#endif
		
		~Texture();
		
		bool setBackground();
		
		bool drawTexture(const int x=0, const int y=0)const;
		bool drawTexture(const int x, const int y,  const unsigned int source_start_x , const unsigned int source_start_y , const unsigned int width , const unsigned int height)const;
		
		int getWidth(void)const { return width; };
		int getHeight(void)const { return height; };
		
		bool error(void)const { return data == NULL; };
};

#endif 
