#include "Player.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "Keyboard.hpp"
#include "Output.hpp"
#include "Time_Manager.hpp"
#include "Position.hpp"

#include <iostream>

/**
	Player's constructor 
	@param const Position& initial_pos : the position at the beginning
*/
Player :: Player (const Position& initial_pos):World_Entities(initial_pos,EntitiesType::PLAYER)
{
	// Set the life
	life = 100;

	// Set the time to manage the shoot frequency
	shoot_time = blackbox::getTime();

	blackbox::showMessage("Player created");
}

/**
	Overloading of the move function from World_Entities.
	Manage the movements of the player.
	Following the keys pressed we moved the player
	Can not go out the screen
*/
void Player :: move(void)
{
	if ( pos.x > 0 )	// Check the left border
		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_LEFT))
			pos.x-=3;

	if ( (unsigned)pos.x + (Visualisation::getVisualisation())->getTextureWidth(texture) < (Visualisation::getVisualisation())->getWidth()-SIZE_UI )	// Check the right border
		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_RIGHT))
			pos.x+=3;


	if ( pos.y > 0 )	// Check the up border
		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_UP))
			pos.y-=3;

	if ( (unsigned)pos.y + (Visualisation::getVisualisation())->getTextureHeight(texture) < (Visualisation::getVisualisation())->getHeight()-1 )	// Check the down border
		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_DOWN))
			pos.y+=3;

	if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_SPACE))
		if ( blackbox::getTime() - shoot_time > 250 )	// Frequency ( each 1/4  s )
		{
			(World::getWorld())->addBullet(EntitiesType::BULLET2,Position(pos.x-SIZE_SPRITES,pos.y),-15,0);
			shoot_time = blackbox::getTime();	// update the time
		}
}

