#ifndef __LEVEL_HPP__
#define __LEVEL_HPP__

#include "Position.hpp"

#include <string>
#include <vector>

/**
	Structure to save the informations from the file
*/
typedef struct Level_Element
{
	unsigned char type;	// Type of the enemy
	Position pos;	// Position of the enemy
	unsigned int time;	// Time when the enemy appears

	// Constructor
	Level_Element(const unsigned char type, const Position pos, const unsigned int time):type(type),pos(pos),time(time) {};
}Level_Element;

class Level
{
	private:
		unsigned int starting_time;	// To know when we have started the level
		unsigned int offset;	// Offset for the already created enemies

		std::vector <Level_Element*>level_elements;

		// Background texture path ( they are defined in the level file )
		std::string text1;
		std::string text2;

		// File parser
		bool loadFile(const std::string& path);

	public:
		Level(const unsigned char level);
		~Level(void);

		bool update(void);

		unsigned int getStartingTime(void)const { return starting_time; };

		std::string& getText1(void) { return text1; };
		std::string& getText2(void) { return text2; };
};

#endif
