#ifndef __KEYBOARD_HPP__
#define __KEYBOARD_HPP__

#include "global.hpp"

#ifdef _HAPI
	#include <HAPI_lib.h>

	#define BLACKBOX_ESCAPE 27
	#define BLACKBOX_RETURN HK_RETURN
	#define BLACKBOX_UP		HK_UP
	#define BLACKBOX_DOWN	HK_DOWN
	#define BLACKBOX_LEFT	HK_LEFT
	#define BLACKBOX_RIGHT	HK_RIGHT
	#define BLACKBOX_SPACE	HK_SPACE
	#define BLACKBOX_S		'S'
	#define BLACKBOX_Q		'Q'
	#define BLACKBOX_D		'D'
	#define BLACKBOX_Z		'Z'
	#define BLACKBOX_F		'F'
#endif
#ifdef _SDL
	#include <SDL/SDL.h>

	#define BLACKBOX_ESCAPE	27
	#define BLACKBOX_RETURN SDLK_RETURN
	#define BLACKBOX_UP		SDLK_UP
	#define BLACKBOX_DOWN	SDLK_DOWN
	#define BLACKBOX_LEFT	SDLK_LEFT
	#define BLACKBOX_RIGHT	SDLK_RIGHT
	#define BLACKBOX_SPACE	SDLK_SPACE
	#define BLACKBOX_S		SDLK_s
	#define BLACKBOX_Q		SDLK_q
	#define BLACKBOX_D		SDLK_d
	#define BLACKBOX_Z		SDLK_z
	#define BLACKBOX_F		SDLK_f
#endif

namespace blackbox
{
	class Keyboard
	{
		private:
			static Keyboard* keyboard;
			
			Keyboard(void);
			~Keyboard(void);
			
			#ifdef _SDL
				SDL_Event* event;
				Uint8* keyStates;
			#endif
			#ifdef _HAPI
				HAPI_TKeyboardData* k_data;
				HAPI_TMouseData* m_data;
			#endif
		
		public:	
		
			static Keyboard* getKeyboard(void);
			void destroyKeyboard(void);
			
			/*
			 * Keyboard
			 */
			bool getEscape(void);
			bool getKeyDown(const int);
			bool getModCtrlDown(void);
			bool getModShiftDown(void);
			
			/*
			 * Mouse
			 */
			bool getLeftClick(void);
			bool getRightClick(void);
			
			void getMousePosition(int* x, int* y);
	};
}

#endif
