#include "Colour.hpp"

#include "global.hpp"

#include "Visualisation.hpp"

#ifdef _SDL

	#include <SDL/SDL.h>

	unsigned int blackbox::getSDLColour(const blackbox::TColour& colour)
	{
		return SDL_MapRGBA(((Visualisation::getVisualisation())->getSDL_window())->format , colour.red , colour.green , colour.blue , colour.alpha );
	}

#endif

#ifdef _HAPI
	
	HAPI_TColour blackbox::getHAPIColour(const blackbox::TColour& colour)
	{
		return HAPI_TColour(colour.red,colour.green,colour.blue,colour.alpha);
	}
	
#endif
