#include "Bullet2.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "Colour.hpp"
#include "Sound.hpp"
#include "Output.hpp"

#include "Position.hpp"

#include "math.h"

/**
	Bullet2's constructor
*/
Bullet2 :: Bullet2(const Position& initial_pos, const int dx, const int dy):Bullet(initial_pos,EntitiesType::BULLET2,5,dx,dy)
{
	isAnimation = true;
	counter = 0;

	blackbox::showMessage("Bullet Type 2 created");
}

/**
	Function to move the bullet
	Move in a linear way on x axis
	Move in a sinus way on y axis
*/
void Bullet2 :: move(void)
{
	pos.x += dx;
	pos.y += (int)(cosf(counter)*5);

	counter +=0.3f;

	// Checks to know if the bullet become useless ( out of screen )
    if ( pos.y < -SIZE_SPRITES ||pos.y > (signed)Visualisation::getVisualisation()->getHeight())	// On y axis
	{
		World::getWorld()->deleteElement(this);
		return;
	}

	if ( pos.x < -SIZE_SPRITES || pos.x > (signed)Visualisation::getVisualisation()->getWidth()-SIZE_UI-SIZE_SPRITES)	// On x axis
	{
		World::getWorld()->deleteElement(this);
		return;
	}	
}

