#include "Background.hpp"

#include "Visualisation.hpp"
#include "Output.hpp"

/**
	Background's constructor
	@param const std::string& file1 : the first background file
	@param const std::string& file2 : the second background file
*/
Background :: Background(const std::string& file1, const std::string& file2)
{
	// Load the background files
	text1 = (Visualisation::getVisualisation())->addTexture(file1);
	text2 = (Visualisation::getVisualisation())->addTexture(file2);

	x1 = 0;
	x2 = 0 - (Visualisation::getVisualisation())->getTextureWidth(text2);

	blackbox::showMessage("Background created");
}


void Background ::  draw(void)
{
	(Visualisation::getVisualisation())->drawTexture(text1,x1,0);
	(Visualisation::getVisualisation())->drawTexture(text2,x2,0);
}

void Background :: update(void)
{
	if ( (unsigned)x1 == Visualisation::getVisualisation()->getTextureHeight(text1) )
		x1 = 0 - Visualisation::getVisualisation()->getTextureHeight(text1) ;
	if ( (unsigned)x2 == Visualisation::getVisualisation()->getTextureHeight(text2) )
		x2 = 0 - Visualisation::getVisualisation()->getTextureHeight(text2) ;
	x1++;
	x2++;
}
