#include "menu.hpp"

#include "Visualisation.hpp"
#include "TextRender.hpp"
#include "Colour.hpp"
#include "Keyboard.hpp"
#include "Time_Manager.hpp"

/**
	Menu's constructor
*/
Menu :: Menu(void):difficulty(1),selection(0)
{
	key_time = blackbox::getTime();
}

/**
	Function to draw the menu
	The menu is composed by three possibilities :
		- Play
		- Difficulty :
		- Quit
	@return char :
		- -1 if we must quit the game
		- 0 if we do nothing special
		- 1 if we start the game
*/
char Menu :: draw(void)
{
	// Display the menu texts
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*2,50,"Play",blackbox::TColour());

	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - (int)(SIZE_FONT*2.5),250,"Difficulty :",blackbox::TColour());
	switch ( difficulty )
	{
		case 1 :
			blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*2,300,"Easy",blackbox::TColour(20,180,50));
			break;
		case 2 :
			blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*2,300,"Hard",blackbox::TColour(180,20,50));
			break;
	}

	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*2,450,"Quit",blackbox::TColour());

	// Display the menu selected
	switch ( selection )
	{
		case 0 :
			blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*2,50,"Play",blackbox::TColour(255,0,0));
			break;
		case 1 :
			blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - (int)(SIZE_FONT*2.5),250,"Difficulty :",blackbox::TColour(255,0,0));
			break;
		case 2 :
			blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*2,450,"Quit",blackbox::TColour(255,0,0));
			break;
	}

	// Manage the user events
	if ( blackbox::getTime() - key_time > 200 )
	{
		if ( !blackbox::Keyboard::getKeyboard()->getEscape())
			return false;
		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_UP) )
			if ( selection != 0 )
				selection --;
			else
				selection = 2;

		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_DOWN) )
			if ( selection != 2 )
				selection ++;
			else
				selection = 0;

		if ( blackbox::Keyboard::getKeyboard()->getKeyDown(BLACKBOX_SPACE) )
		{
			switch ( selection )
			{
				case 0 :
					return 1;
					break;
				case 1 :
					if ( difficulty == 1 )
						difficulty = 2;
					else
						difficulty = 1;
					break;
				case 2 :
					return -1;
			}
		}
		key_time = blackbox::getTime();
	}
	return 0;

}
