#include "Visualisation.hpp"
#include "Sound.hpp"
#include "Colour.hpp"
#include "TextRender.hpp"
#include "Keyboard.hpp"
#include "Time_Manager.hpp"

#include "menu.hpp"
#include "World.hpp"

#include <iostream>

#include <time.h>
#include <stdlib.h>

#ifdef _DEBUG
#define CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#endif

// Variable shared between the file , to stop correctly the program if something goes wrong
bool somethingWrong = false;

#ifdef _HAPI
	void HAPI_Main()
#endif
#ifdef _SDL
	int main()
#endif
{
	#ifdef _DEBUG
  _CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
  //_CrtSetBreakAlloc(4244);
	#endif
	
	Menu menu;
	Visualisation* visu = Visualisation::getVisualisation(640,480,false);
	World* world = NULL;
	unsigned int last_time = blackbox::getTime();
	bool draw_menu = true;	// Boolean if menu needs to be draw ; or if the world must be stopped
	int menu_music = 0, game_music = 0;
	blackbox::Sound::getSound()->loadSound("Data/Sfx/Menu_music.wav",&menu_music);
	blackbox::Sound::getSound()->loadSound("Data/Sfx/Game_music.wav",&game_music);
	
	if ( visu == NULL )
	{
		#ifdef _SDL
			return 1;	
		#endif
		#ifdef _HAPI
			return;
		#endif
	}

	blackbox::Sound::getSound()->playSound(menu_music,0,900);	// Start menu_music

	while ( visu->run() && !somethingWrong )
	{
		visu->clearScreen(blackbox::TColour(0,0,0));

		if ( draw_menu )
		{
			if ( world != NULL )
			{
				blackbox::Sound::getSound()->stopSound(game_music);	// Stop the game music
				// End of the world after a game
				world->destroyWorld();
				world=NULL;
				blackbox::Sound::getSound()->playSound(menu_music,0,900);	// Start menu music
			}
			switch ( menu.draw() )
			{
				case -1 :
					somethingWrong = true;	// Causes the stop of the game ; not really a true something wrong because it is the user that ask this.
					break;
				case 1:
					draw_menu = false;
					break;
			}
		}
		else
		{
			if ( world == NULL )
			{
				blackbox::Sound::getSound()->stopSound(menu_music);	// Stop the menu music
				world = World::getWorld(menu.getDifficulty());
				world->loadLevel();
				blackbox::Sound::getSound()->playSound(game_music,0,900);	// Start game music
			}
	
			draw_menu = !(world->draw());
			
			if ( blackbox::getTime() - last_time > 50 / (unsigned)menu.getDifficulty() )	// Wait for update the World
			{
				world->update();
				last_time = blackbox::getTime();
			}
		}
	}

	blackbox::Sound::getSound()->stopSound();
	
	/* Destructions of the singletons */
	if ( world != NULL )
		world->destroyWorld();
	(blackbox::Keyboard::getKeyboard())->destroyKeyboard();
	(blackbox::TextRender::getTextRender())->destroyTextRender();
	(blackbox::Sound::getSound())->destroySound();
	visu->destroyVisualisation();
	
	#ifdef _SDL
		return 0;	
	#endif
	#ifdef _HAPI
		return;
	#endif
}
