#ifndef __EXCEPTION_HPP__
#define __EXCEPTION_HPP__

#include <exception>

#include <string>

using namespace std;

class InitException: public exception
{
	private:
		int level;
		std::string user_message;
		std::string error_file;
		unsigned long error_line;
	public:
	
	InitException(const unsigned int level=0,const string& user_message="", const string& error_file = "", const unsigned long error_line = 0) throw () :level(level),user_message(user_message),error_file(error_file),error_line(error_line) {}
	virtual ~InitException() throw() {}
	
	
	virtual const char* what() const throw ()
	{
		string error_message;
		
		switch(level)
		{
			case 1: error_message = "Fatal error!";
				break;
			default: error_message = "Output!";
		}
		
		error_message.append(user_message);
		error_message.append(" in : ");
		error_message.append(error_file);
		error_message.append(" at line : ");
		 //error_line;
		
		return error_message.c_str();
	}
};

#endif
