#ifndef __VISUALISATION_HPP__
#define __VISUALISATION_HPP__

class Texture;
class Animation;

#include "global.hpp"

#include "Colour.hpp"

#include <vector>
#include <string>

#ifdef _SDL
	struct SDL_Surface;
#endif
#ifdef _HAPI
//	typedef BYTE;
//	typedef DWORD;
#endif

class Visualisation
{
	private:
	
		static Visualisation* window;
	
		Visualisation(const int width, const int height, const bool fullscreen);
		~Visualisation(void);
		
		#ifdef _SDL
		
			bool setSDLPixel(const unsigned int x , const unsigned int y, const unsigned int colour);
			unsigned int getSDLPixel(const unsigned int x, const unsigned int y);
		
			SDL_Surface* SDL_window;
		#endif
		#ifdef _HAPI

			bool setHAPIPixel(const unsigned int x, const unsigned int y, const unsigned char r, const unsigned char g, const unsigned char b);
			bool setHAPIPixel(const unsigned int x, const unsigned int y, const unsigned char r, const unsigned char g, const unsigned char b, const unsigned char alpha);

			BYTE* screen_data;
			DWORD* DW_screen_data;

		#endif
		
		unsigned int width;
		unsigned int height;
		
		unsigned int time_ellapsed;
		
		std::vector<Texture*> listTexture;
		std::vector<Animation*> listAnimation;
		
	public:
	
		static Visualisation* getVisualisation(void);
		static Visualisation* getVisualisation(const int width, const int height, const bool fullscreen = false);
		
		void destroyVisualisation(void);
		
		bool run(const unsigned int refresh_time = 0);
		
		#ifdef _SDL
			SDL_Surface* getSDL_window(void) { return SDL_window; };
		#endif
		#ifdef _HAPI
			bool cpyToScreen(BYTE* const source);
			bool cpyToPartOfScreen(BYTE* const source, const unsigned int pos_x , const unsigned int pos_y , const unsigned int size);
		#endif
		
		blackbox::TColour getPixel(const unsigned int x, const unsigned int y);
		bool setPixel(const unsigned int x , const unsigned int y , const blackbox::TColour&);
		
		void clearScreen(void);
		void clearScreen(const blackbox::TColour& );
		
		unsigned int getWidth()const { return width; };
		unsigned int getHeight()const { return height; };
		
		
		/**
		 * Texture
		 **/
		
		int addTexture(const std::string& name);
		int addTexture(const std::string& name, const blackbox::TColour& transparancy);
		
		bool drawTexture(const int id, const int x =0 , const int y =0) const;
		bool drawTexture(const int id, const int pos_x , const int pos_y, const unsigned int source_start_x , const unsigned int source_start_y , const unsigned int width , const unsigned int height) const;
		
		unsigned int getTextureWidth(const int id)const;
		unsigned int getTextureHeight(const int id)const;
		
		/**
		 * Animation
		 **/
		
		int addAnimation(const std::string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y, unsigned long tempo);
		int addAnimation(const std::string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y, unsigned long tempo, const blackbox::TColour& transparancy);
		int addAnimation(const std::string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y, unsigned long tempo,const unsigned int offset_x,const unsigned int offset_y,const unsigned int size_x,const unsigned int size_y);
		int addAnimation(const std::string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y, unsigned long tempo,const unsigned int offset_x,const unsigned int offset_y,const unsigned int size_x,const unsigned int size_y, const blackbox::TColour& transparancy);

		bool drawAnimation(const int id, const int x =0 , const int y =0, unsigned int* anim_number=NULL, unsigned int* time=NULL, const unsigned int tempo=10000000  )const;
		bool drawAnimation(const int id, const int pos_x , const int pos_y, const unsigned int source_start_x , const unsigned int source_start_y , const unsigned int width , const unsigned int height, unsigned int* anim_number=NULL, unsigned int* time=NULL , const unsigned int tempo=10000000 )const;
};

#endif
