#include "Ship3.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "Time_Manager.hpp"
#include "Colour.hpp"
#include "Sound.hpp"
#include "Output.hpp"

#include <math.h>

/**
Constructor for the Ship2
@param const Position& initial_pos : the initial position
*/
Ship3 :: Ship3(const Position& initial_pos):World_Entities(initial_pos,EntitiesType::SHIP3)
{
	// Set the life
	life = 30;

	shoot_frequency = 350;
	time = blackbox::getTime();

	direction = true;

	blackbox::showMessage("Ship3 created");
}

/**
	Function to move the Ship3
	The ship moves by bounding on the y border
*/
void Ship3 :: move (void)
{
	pos.x+=6;
	if ( direction )
		pos.y+=5;
	else
		pos.y-=5;

	if ( pos.y <= 0 || (unsigned)pos.y + SIZE_SPRITES > Visualisation::getVisualisation()->getHeight())
		direction = !(direction);

	if ( blackbox::getTime() - time > shoot_frequency )	// Limit the frequency
	{
		if ( rand() % (15/World::getWorld()->getDifficulty()) == 0 )	// Limit the possibility to shoot following the difficulty`
			World::getWorld()->addBullet(EntitiesType::BULLET3, Position(pos.x+SIZE_SPRITES,pos.y),6,0);
		time = blackbox::getTime();
	}

	if ( pos.x > (signed)(Visualisation::getVisualisation())->getWidth()-SIZE_UI )
		World::getWorld()->deleteElement(this);
}

