#include "Ship2.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "Time_Manager.hpp"
#include "Colour.hpp"
#include "Sound.hpp"
#include "Output.hpp"

#include <math.h>

/**
	Constructor for the Ship2
	@param const Position& initial_pos : the initial position
*/
Ship2 :: Ship2(const Position& initial_pos):World_Entities(initial_pos,EntitiesType::SHIP2)
{
	// Set the life
	life = 10;

	shoot_frequency = 250;
	time = blackbox::getTime();
	
	counter=0;

	blackbox::showMessage("Ship2 created");
}

/**
	Function to move the Ship2
	The ship moves following a cosines
*/
void Ship2 :: move (void)
{
	pos.x+=4;
	pos.y+= (int)(cosf(counter)*10);
	
	// The cosines changes following the difficulty
	counter += 0.1f * (int)World::getWorld()->getDifficulty();

	if ( blackbox::getTime() - time > shoot_frequency )	// Limit the frequency
	{
		if ( rand() % (20/World::getWorld()->getDifficulty()) == 0 )	// Limit the possibility to shoot following the difficulty`
			World::getWorld()->addBullet(EntitiesType::BULLET2, Position(pos.x+SIZE_SPRITES,pos.y),5,0);
		time = blackbox::getTime();
	}

	if ( pos.x > (signed)(Visualisation::getVisualisation())->getWidth()-SIZE_UI )
		World::getWorld()->deleteElement(this);
}

