#include "Ship1.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "Time_Manager.hpp"
#include "Colour.hpp"
#include "Sound.hpp"
#include "Output.hpp"

/**
	Constructor for the Ship1
	@param const Position& initial_pos : the initial position
*/
Ship1 :: Ship1(const Position& initial_pos):World_Entities(initial_pos,EntitiesType::SHIP1)
{
	// Set the life
	life = 20;

	shoot_frequency = 500;
	time = blackbox::getTime();

	blackbox::showMessage("Ship1 created");
}

/**
	Function to move the Ship1
*/
void Ship1 :: move (void)
{
	pos.x+=5;

	if ( blackbox::getTime() - time > shoot_frequency )	// Limit the frequency
	{
		if ( rand() % (20/World::getWorld()->getDifficulty()) == 0 )	// Limit the possibility to shoot following the difficulty`
			World::getWorld()->addBullet(EntitiesType::BULLET1, Position(pos.x+SIZE_SPRITES,pos.y),6,0);
		time = blackbox::getTime();
	}

	if ( pos.x > (signed)(Visualisation::getVisualisation())->getWidth()-SIZE_UI )
		World::getWorld()->deleteElement(this);
}
