#ifndef __POSITION_HPP__
#define __POSITION_HPP__

/**
	Structure to manage the positions
*/
typedef struct Position
{
	int x;
	int y;

	// Constructors
	Position():x(0),y(0) {}
	Position(const int x, const int y):x(x),y(y) {}

}Position;

// Some basic operators are overloaded
Position operator+ (const Position& lpos, const Position& rpos );
Position operator- (const Position& lpos, const Position& rpos );
Position operator* (const float coef, const Position& pos);


#endif
