#include "Position.hpp"

/**
	Operator for add two Positions
*/
Position operator+ (const Position& lpos, const Position& rpos )
{
	return Position ( lpos.x + rpos.x , lpos.y + rpos.y );
}

/**
	Operator for sub two Positions
*/
Position operator- (const Position& lpos, const Position& rpos )
{
	return Position ( lpos.x - rpos.x , lpos.y - rpos.y );
}

/**
	Operator for multiply a coef with a Position
*/
Position operator* (const float coef, const Position& pos)
{
	return Position ( (int)(coef * pos.x) , (int)(coef * pos.y) );
}
