#ifndef __COLOUR_HPP__
#define __COLOUR_HPP__

#include "global.hpp"

#ifdef _HAPI
	#include <HAPI_lib.h>
#endif

namespace blackbox
{
	typedef struct TColour
	{
		unsigned char red;
		unsigned char green;
		unsigned char blue;
		unsigned char alpha;

		TColour():red(255),green(255),blue(255),alpha(255) {};
		TColour(const unsigned char red, const unsigned char green, const unsigned char blue):red(red),green(green),blue(blue),alpha(255) {};
		TColour(const unsigned char red, const unsigned char green, const unsigned char blue, const unsigned char alpha):red(red),green(green),blue(blue),alpha(alpha) {};
	}TColour;

	unsigned int getSDLColour(const TColour& colour);
	#ifdef _HAPI
		HAPI_TColour getHAPIColour ( const TColour& colour);
	#endif
	
}

#endif
