#include "Collision.hpp"

#include "World_Entities.hpp"

#include "Visualisation.hpp"

/**
	Function to know if a collision exists between elem1 and elem2
	@param const World_Entities* elem1 : the first element
	@param const World_Entities* elem2 : the second element
	@return bool : true if the elements are colliding
*/
bool getCollision(const World_Entities* elem1, const World_Entities* elem2)
{
	if ( elem1 == elem2 )
		return false;
	if ( elem1->getType() == EntitiesType::EXPLOSION1 || elem2->getType() == EntitiesType::EXPLOSION1 || elem1->getType() == elem2->getType() )
		return false;
	
	// Get the coordinates ( simplify a bit the if part )
	int elem1_x = elem1->getPosX();// + 4;
	int elem1_y = elem1->getPosY();// + 4;
	int elem1_max_x = elem1_x + (Visualisation::getVisualisation())->getTextureWidth(elem1->getTexture()) - 4;
	int elem1_max_y = elem1_y + (Visualisation::getVisualisation())->getTextureHeight(elem1->getTexture()) - 4;

	int elem2_x = elem2->getPosX();// + 4;
	int elem2_y = elem2->getPosY();// + 4;
	int elem2_max_x = elem2_x + (Visualisation::getVisualisation())->getTextureWidth(elem2->getTexture()) - 4;
	int elem2_max_y = elem2_y + (Visualisation::getVisualisation())->getTextureHeight(elem2->getTexture()) - 4;

	// Test for the collision
	if ( ( elem1_x >= elem2_x && elem1_x < elem2_max_x )
			|| ( elem1_max_x >= elem2_x && elem1_max_x < elem2_max_x ) )
			if ( ( elem1_y >= elem2_y && elem1_y < elem2_max_y )
				|| ( elem1_max_y >= elem2_y && elem1_max_y < elem2_max_y ) )
				return true;
	return false;
}
