#include "Window/Window.hpp"
#include "Sound/Music.hpp"

#include <QApplication>
#include <QMessageBox>

int main(int argc, char** argv)
{
	QApplication a(argc,argv);
	
	// Start the FMOD engine
	if ((Music::getInstance()).create() == false )
	{
		QMessageBox::critical(0, "FMOD Initialisation", "Error during the FMOD initialisation");
		(Music::getInstance()).deleteInstance();
		return EXIT_FAILURE;
	}
	
	Window win(0,"FMOD Analizer");
	
	win.show();
	
	return a.exec();
}
